// napple1 ncurses Apple 1 emulator
// Copyright (C) 2008 Nobu Hatano
//
// Pom1 Apple 1 Emulator
// Copyright (C) 2000 Verhille Arnaud
// Copyright (C) 2006 John D. Corrado
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, 
// USA.

#include <string.h>
#include "screen.h"
#include <ncurses.h>
#include <time.h>
#include <unistd.h>

static unsigned char screenTbl[960];
static int indexX, indexY, terminalSpeed = 60;
static int nrow, ncol;

void resetScreen(void)
{
	indexX = indexY = 0;

	if ((nrow = tigetnum("lines")) > 24 || nrow < 1)
		nrow = 24;
	if ((ncol = tigetnum("cols")) > 40 || ncol < 1)
		ncol = 40;

	memset(screenTbl, 0, nrow * ncol);

	updateScreen();
}

void setTerminalSpeed(int ts)
{
	terminalSpeed = ts;
}

int getTerminalSpeed(void)
{
	return terminalSpeed;
}

static void synchronizeOutput(void)
{
	int sleepMillis = (int)(1000000 / terminalSpeed);

	usleep(sleepMillis);
}

static void newLine(void)
{
	int i;

	for (i = 0; i < (nrow-1) ; ++i)
		memcpy(&screenTbl[i * ncol], 
		       &screenTbl[(i + 1) * ncol], 
		       ncol);

	memset(&screenTbl[ncol * (nrow-1)], 0, ncol);
}

void outputDsp(unsigned char dsp)
{
	switch (dsp)
	{
	case 0x5F:
		if (indexX == 0)
		{
			indexY--;
			indexX = ncol-1;
		}
		else
			indexX--;

		screenTbl[indexY * ncol + indexX] = 0;
		break;
	case 0x0A:
	case 0x0D:
		indexX = 0;
		indexY++;
		break;
	case 0x00:
	case 0x7F:
		break;
	default:
		screenTbl[indexY * ncol + indexX] = dsp;
		indexX++;
		break;
	}

	if (indexX == ncol)
	{
		indexX = 0;
		indexY++;
	}
	if (indexY == nrow)
	{
		newLine();
		indexY--;
	}

	updateScreen();

	synchronizeOutput();
}

void updateScreen(void)
{
	int i, j;
	unsigned char c;

	erase();

	for (j = 0; j < nrow; ++j)
	{
		for (i = 0; i < ncol; ++i)
		{
		  	move(j, i);
			c = screenTbl[j * ncol + i];
			if (c < '!') 
				c = ' ';
			printw("%c", c);
		}
	}

	move(indexY, indexX); /* put cursor */

	refresh();
}

void drawCharacter(int xPosition, int yPosition, unsigned char characNumber)
{
		move(yPosition, xPosition);
		printw("%c", characNumber);
}

